//
//  OrderCell.swift
//  We1l
//
//  Created by Yahya Tabba on 2/22/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit
import SwiftyJSON
import AFDateHelper

class OrderCell: UITableViewCell {
    
    
    @IBOutlet weak var orderNumberLbl : UILabel!
    @IBOutlet weak var orderAWBfLBl : UILabel!
    @IBOutlet weak var orderStatusLbl : UILabel!
    @IBOutlet weak var orderAddress : UILabel!
    @IBOutlet weak var dateLbl : UILabel!
    
    var parentVC : MyOrdersVC?
    
    var order : Order!{
        didSet{
            self.orderNumberLbl.text = order.OrderNumber
            self.orderAWBfLBl.text = order.AWBNumber
            self.orderStatusLbl.text = order.Status
            self.orderAddress.text = order.Address
            let d = Date.init(timeIntervalSince1970: self.order.AddDateTime.doubleValue)
            self.dateLbl.text = d.toString(format: DateFormatType.isoDate)
        }
    }
    
    
    @IBAction func openDetails(){
        self.parentVC?.openDetails(self.tag)
    }
    
    @IBAction func openTrack(){
        self.parentVC?.openTrack(self.tag)
    }
    
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
        
        // Configure the view for the selected state
    }
    
}
