//
//  ProductCell.swift
//  We1l
//
//  Created by Yahya Tabba on 2/11/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit
import SwiftyJSON

class ProductCell: UICollectionViewCell {
    
    @IBOutlet weak var img : UIImageView!
    @IBOutlet weak var nameLbl : UILabel!
    @IBOutlet weak var contentLbl : UILabel!
    @IBOutlet weak var priceLbl : UILabel!
    @IBOutlet weak var wishlistBtn : UIButton!
    var parentVC : CategoriesVC?
    var parentVC2 : FavoritesVC?
    
    var product : Product!{
        didSet{
            Provider.sd_setImage(self.img, urlString: product.Images.NoColor.first)
            self.nameLbl.text = product.Name
//            self.contentLbl.text = product.SKU//product.Content
            self.priceLbl.text = product.Price.fromPrice + " " + Provider.currentLocation.symbol
            
            self.wishlistBtn.isHidden = (product.IsLiked == nil)
            
            if let IsLiked = product.IsLiked{
                let image = IsLiked.Boolean ?  #imageLiteral(resourceName: "baseline_favorite_black_24pt") : #imageLiteral(resourceName: "baseline_favorite_border_black_24pt")
                self.wishlistBtn.setImage(image, for: UIControl.State.normal)
            }
        }
    }
    
    var productWishlist : Product!{
        didSet{
            self.nameLbl.text = productWishlist.Name
            self.priceLbl.text = productWishlist.Price.fromPrice + " " + Provider.currentLocation.symbol
            Provider.sd_setImage(self.img, urlString: productWishlist.Images.NoColor.first)
        }
    }
    
    
    @IBAction func wishlistAction(){
        
        self.parentVC?.showLoading()
        guard self.productWishlist.IsLiked != nil else {
            return
        }
        
        if self.productWishlist.IsLiked.Boolean{
            Communication.shared.deleteWish(ProductID: product.ID.stringValue) { (res) in
                self.parentVC?.hideLoading()
                self.parentVC?.products[self.tag].IsLiked = JSON(false)
                self.parentVC?.collectionView.reloadItems(at: [IndexPath.init(item: self.tag, section: 1)])
            }
        }else{
            Communication.shared.addWish(ProductID: product.ID.stringValue) { (res) in
                self.parentVC?.hideLoading()
                self.parentVC?.products[self.tag].IsLiked = JSON(true)
                self.parentVC?.collectionView.reloadItems(at: [IndexPath.init(item: self.tag, section: 1)])
            }
        }
        
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }
    
}
