//
//  TodayHomeCell.swift
//  We1l
//
//  Created by Yahya Tabba on 2/9/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit

class TodayHomeCell: UICollectionViewCell {

    @IBOutlet weak var img : UIImageView!
    @IBOutlet weak var nameLbl : UILabel!
    @IBOutlet weak var brandLbl : UILabel!

    @IBOutlet weak var likedBtn : UIButton!

    
    var product : Product!{
        didSet{
            Provider.sd_setImage(img, urlString: product.Images3.first?.ImageURL, placeholderImage: nil) { (res, err, cache, url) in
                self.nameLbl.text = self.product.Name
                self.brandLbl.text = self.product.BrandName
            }

            self.nameLbl.text = product.Name
            self.brandLbl.text = product.BrandName

            self.likedBtn.setImage(self.product.IsLiked.Boolean ? #imageLiteral(resourceName: "baseline_favorite_black_24pt") : #imageLiteral(resourceName: "baseline_favorite_border_black_24pt"), for: .normal)
        }
    }
    
    
    var moreProduct : Product!{
        didSet{
            Provider.sd_setImage(img, urlString: moreProduct.Images2.first, placeholderImage: nil) { (res, err, cache, url) in
                self.nameLbl.text = self.moreProduct.Name
                self.brandLbl.text = self.moreProduct.BrandName
            }
            
            self.nameLbl.text = moreProduct.Name
            self.brandLbl.text = moreProduct.BrandName
            
            self.likedBtn.setImage(self.moreProduct.IsLiked.Boolean ? #imageLiteral(resourceName: "baseline_favorite_black_24pt") : #imageLiteral(resourceName: "baseline_favorite_border_black_24pt"), for: .normal)
        }
    }

    
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

}
