//
//  AddNewReqVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/17/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit
import AFDateHelper
import DropDown
import DatePickerDialog
import Alamofire

class AddNewReqVC: BaseVC {
    
    @IBOutlet weak var tfName : UITextField!
    @IBOutlet weak var tfEmail : UITextField!
    @IBOutlet weak var tfTelephone : UITextField!
    @IBOutlet weak var tfMobile : UITextField!
    @IBOutlet weak var tfTitle : UITextField!
    @IBOutlet weak var tfDays : UITextField!
    @IBOutlet weak var tfContent : UITextView!
    @IBOutlet weak var img : UIImageView!
    @IBOutlet weak var imgBtn : UIButton!
    
    @IBOutlet weak var tfType : UITextField!
    @IBOutlet weak var tfSize : UITextField!
    @IBOutlet weak var tfDate : UITextField!
    
    var typeDropDown = DropDown()
    var sizeDropDown = DropDown()
    let sizesArray : [(String,String,CGFloat,CGFloat)] = [("Full (1800x600)","Full",1800,600),
                                                          ("Mid (900x450)","Mid",900,450),
                                                          ("Small (600x600)","Small",600,600)]
    
    var selectedDate : String!
    var selectedType : String!
    var selectedSize : (String,String,CGFloat,CGFloat)!
    var url : URL!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.navigationItem.title = "REQUEST AD".localized
        self.largeTitle()
        self.addLogoTop()

        
        setupTypes()
        setupSizes()
    }
    
    func setupTypes(){
        let array = ["Gold","Sliver","Bronze"]
        typeDropDown.dataSource = array
        typeDropDown.anchorView = self.tfType
        typeDropDown.direction = .any
        typeDropDown.bottomOffset = CGPoint(x: 0, y: tfType.bounds.height)
        
        typeDropDown.selectionAction = { [unowned self] (index, item) in
            self.tfType.text = item
            self.selectedType = item
        }
    }
    
    func setupSizes(){
        
        self.tfSize.text = sizesArray.first?.0
        self.selectedSize = sizesArray.first
        
        sizeDropDown.dataSource = sizesArray.map({$0.0})
        sizeDropDown.anchorView = self.tfSize
        sizeDropDown.direction = .any
        sizeDropDown.bottomOffset = CGPoint(x: 0, y: tfSize.bounds.height)
        
        sizeDropDown.selectionAction = { [unowned self] (index, item) in
            self.tfSize.text = item
            self.selectedSize = self.sizesArray[index]
        }
    }
    
    
    
    
    @IBAction func openType(){
        self.typeDropDown.show()
    }
    
    @IBAction func openSize(){
        self.sizeDropDown.show()
    }
    
    @IBAction func openImage(){
        self.selectPhotoAction()
    }
    
    
    
    @IBAction func openDate(){
        DatePickerDialog.init().show("Select date".localized, doneButtonTitle: "OK".localized, cancelButtonTitle: "CANCEL".localized, defaultDate: Date(), minimumDate: nil, maximumDate: nil, datePickerMode: UIDatePicker.Mode.date) { (res) in
            if let date = res{
                self.selectedDate = date.toString(format: DateFormatType.isoDate)
                self.tfDate.text = date.toString(format: DateFormatType.isoDate)
            }
        }
    }
    
    
    @IBAction func addReqAction(){
        let name = self.tfName.text!
        let email = self.tfEmail.text!
        let telephone = self.tfTelephone.text!
        let mobile = self.tfMobile.text!
        let reqTitle = self.tfTitle.text!
        let days = self.tfDays.text!
        let content = self.tfContent.text!
        
        if self.selectedSize == nil ||
            self.selectedType ==  nil ||
            self.selectedDate == nil{
            self.showMessage("Please enter all fields".localized, type: .toast)
            return
        }
        
        //        self.showLoading()
        //        Communication.shared.addElan(Title: reqTitle, Content: content, StartAt: self.selectedDate, NumberOfDays: days, Name: name, Tel: telephone, Mobile: mobile, Email: email, Type: self.selectedType, PixelSize: self.selectedSize, ImageURL: "") { (res) in
        //            self.hideLoading()
        //        }
        
        
        if let im = self.img.image{
            print("WIDTH : \(im.size.width) - HEIGHT : \(im.size.height)")
        }
        
        self.showLoading()
        Alamofire.upload(
            multipartFormData: { multipartFormData in
                
                if let myURL = self.url{
                    multipartFormData.append(myURL, withName: "File")
                }
                multipartFormData.append(SystemPasscode.getData, withName: "SystemPasscode")
                
                multipartFormData.append(reqTitle.getData, withName: "Title")
                multipartFormData.append(content.getData, withName: "Content")
                multipartFormData.append(self.selectedDate.getData, withName: "StartAt")
                multipartFormData.append(days.getData, withName: "NumberOfDays")
                multipartFormData.append(name.getData, withName: "Name")
                multipartFormData.append(telephone.getData, withName: "Tel")
                multipartFormData.append(mobile.getData, withName: "Mobile")
                multipartFormData.append(email.getData, withName: "Email")
                multipartFormData.append(self.selectedType.getData, withName: "Type")
                multipartFormData.append(self.selectedSize.1.getData, withName: "PixelSize")
                
        },
            to: Communication.shared.baseURL + Communication.shared.addElanURL ,headers : nil,
            encodingCompletion: { encodingResult in
                
                switch encodingResult {
                case .success(let upload, _, _):
                    
                    upload.uploadProgress(closure: { (Progress) in
                        print("Upload Progress: \(Progress.fractionCompleted)")
                        if Progress.fractionCompleted == 1{
                        }
                    })
                    
                    upload.responseObject { (response : DataResponse<CustomResponse>) in
                        debugPrint(response)
                        
                        Communication.shared.output(response)
                        
                        switch response.result{
                        case .success(let value):
                            
                            if value.status{
                                
                                
                                
                            }else{
                                notific.post(name:_RequestErrorNotificationReceived.not, object: value.message)
                            }
                            break
                        case .failure(let error):
                            print(error.localizedDescription)
                            notific.post(name: _ConnectionErrorNotification.not, object: error.localizedDescription)
                            break
                        }
                        
                    }
                case .failure(let encodingError):
                    //                    self.hideLoading()
                    print(encodingError)
                }
        })
    }
    
}

extension AddNewReqVC : UIImagePickerControllerDelegate,UINavigationControllerDelegate{
    
    func SelectPhoto(){
        let imagePickerController = UIImagePickerController()
        imagePickerController.sourceType = .photoLibrary
        imagePickerController.delegate = self
        imagePickerController.allowsEditing = false
        present(imagePickerController, animated: true, completion: nil)
    }
    
    func SelectCamera(){
        if UIImagePickerController.isSourceTypeAvailable(UIImagePickerController.SourceType.camera){
            let imagePicker = UIImagePickerController()
            imagePicker.delegate = self
            imagePicker.sourceType = UIImagePickerController.SourceType.camera;
            imagePicker.allowsEditing = false
            self.present(imagePicker, animated: true, completion: nil)
        }
    }
    
    
    @objc @IBAction func selectPhotoAction() {
        
        let alert = UIAlertController.init(title: nil, message: nil, preferredStyle: .actionSheet)
        
        alert.addAction(UIAlertAction.init(title: "Take a picture".localized, style: .default, handler: { (ac) in
            self.SelectCamera()
        }))
        
        alert.addAction(UIAlertAction.init(title: "Select Photo".localized, style: .default, handler: { (ac) in
            self.SelectPhoto()
        }))
        
        alert.addAction(UIAlertAction.init(title: "CANCEL".localized, style: .cancel, handler: nil))
        
        self.present(alert, animated: true, completion: nil)
    }
    
    
    func imagePickerControllerDidCancel(_ picker: UIImagePickerController) {
        // Dismiss the picker if the user canceled.
        
        picker.dismiss(animated: true, completion: nil)
    }
    
    
    func imagePickerController(_ picker: UIImagePickerController, didFinishPickingMediaWithInfo info: [UIImagePickerController.InfoKey : Any]) {
        
        let selectedImage = info[UIImagePickerController.InfoKey.originalImage] as! UIImage
        
        let w = selectedImage.size.width
        let h = selectedImage.size.height
        
        if w == self.selectedSize.2, h == self.selectedSize.3{
            self.img.image = selectedImage
            self.url = savePhotoLocal(selectedImage)
            print("URLLL : \(self.url != nil)")
            self.imgBtn.setTitle(nil, for: UIControl.State.normal)
        }else{
            self.url = nil
            self.showMessage("\(w) x \(h)\nDoesn't Compatible with size", type: .toast)
            self.imgBtn.setTitle("Select Photo".localized, for: UIControl.State.normal)
        }
        
        // Dismiss the picker.
        picker.dismiss(animated: true, completion: nil)
    }
    
    
    
    func savePhotoLocal(_ img : UIImage) -> URL?{
        let tt = img//.resized(toWidth: 512)
        
        print("WIDTH \(img.size.width) -- HIGHT \(img.size.height)")
        
        var imageData = tt.pngData()
        
        let imageSize: Int = imageData!.count
        print("size of image in KB: %f ", imageSize / 1024)
        
        //        if (imageSize / 1024) > 2000 {
        //            return nil
        //        }
        
        let random = CGFloat.random()
        
        if let dir = FileManager.default.urls(for: .documentDirectory, in: .userDomainMask).first {
            
            let path = dir.appendingPathComponent("imgProfile\(random).png")
            
            //writing
            do {
                try imageData!.write(to: path, options: Data.WritingOptions.atomic)
            }
            catch {}
        }
        
        let rrr = FileManager.default.urls(for: .documentDirectory, in: .userDomainMask).first!
        
        return  rrr.appendingPathComponent("imgProfile\(random).png")
    }
    
    
}


