//
//  BaseTVC.swift
//  We1l
//
//  Created by Yahya Tabba on 1/14/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit
import JGProgressHUD
import KSToastView
import SideMenu

class BaseTVC: UITableViewController {
    
    var hud = JGProgressHUD.init(style: JGProgressHUDStyle.dark)
    var ref = UIRefreshControl()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        configureNavigationBar()
        registerReceivers()
        
        let tap = UITapGestureRecognizer(target: self, action: #selector(self.onTouch))
        tap.cancelsTouchesInView = false
        self.view.addGestureRecognizer(tap)
        
        self.ref.addTarget(self, action: #selector(self.getRefreshing), for: UIControl.Event.valueChanged)
        
        setupViews()
    }
    
    @objc func goToLogin(){
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "LoginVC") as! LoginVC
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
    func largeTitle(){
        if #available(iOS 11.0, *) {
            self.navigationController?.navigationBar.prefersLargeTitles = true
            self.navigationItem.largeTitleDisplayMode = .always
        }
    }
    func hideLargeTitle(){
        if #available(iOS 11.0, *) {
            self.navigationItem.largeTitleDisplayMode = .never
        }
    }

    func addLogoTop() {
        if var h = self.navigationController?.navigationBar.frame.height{
            h = h > 55 ? 44 : h
            let vv = UIView.init(frame: CGRect.init(x: 0, y: 0, width: 200, height: h - 12))
            let img = UIImageView.init(frame: CGRect.init(x: 0, y: 0, width: 200, height: h - 12))
            img.image = UIImage.init(named: "logo2")
            img.contentMode = .scaleAspectFit
            vv.addSubview(img)
            self.navigationItem.titleView = vv
        }
    }
    
    
    func addSideMenuButton(){
        self.navigationItem.leftBarButtonItem = UIBarButtonItem.init(image: #imageLiteral(resourceName: "baseline_menu_black_24pt"), style: .plain, target: self, action: #selector(self.openSideMenu))
    }

    func ConfigSideMenu(){
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "SideMenuVC") as! SideMenuVC
        
        let menuLeftNavigationController = UISideMenuNavigationController(rootViewController: vc)
        menuLeftNavigationController.isNavigationBarHidden = true
        if Local.isArabic(){
            SideMenuManager.default.menuRightNavigationController = menuLeftNavigationController
        }else{
            SideMenuManager.default.menuLeftNavigationController = menuLeftNavigationController
        }
        SideMenuManager.default.menuAddScreenEdgePanGesturesToPresent(toView: self.view, forMenu: UIRectEdge.left)
        
        SideMenuManager.default.menuWidth = UIScreen.main.bounds.width * 2 / 3
        SideMenuManager.default.menuFadeStatusBar = false
        SideMenuManager.default.menuAnimationPresentDuration = 0.3
        SideMenuManager.default.menuAnimationDismissDuration = 0.3
        SideMenuManager.default.menuPresentMode = .menuSlideIn
    }
    
    @objc func openSideMenu(){
        if Local.isArabic(){
            present(SideMenuManager.default.menuRightNavigationController!, animated: true, completion: nil)
        }else{
            present(SideMenuManager.default.menuLeftNavigationController!, animated: true, completion: nil)
        }
    }
    
    
    @objc func getRefreshing(){
        
    }
    
    func getData(){
        //self.showLoading()
        getRefreshing()
    }
    
    func setupViews(){
        
    }
    
    func configureNavigationBar() {
        //setup back button
        self.navigationItem.hidesBackButton = false
        let rr = UIBarButtonItem(title: "", style: UIBarButtonItem.Style.plain, target: nil, action:nil)
        self.navigationItem.backBarButtonItem = rr
    }
    
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        unregisterReceivers()
        registerReceivers()
    }
    
    override func viewDidDisappear(_ animated: Bool) {
        super.viewDidDisappear(animated)
        unregisterReceivers()
    }
    
    
    func registerReceivers()
    {
        notific.addObserver(self, selector: #selector(self.connectionErrorNotificationReceived(_:)), name: _ConnectionErrorNotification.not, object: nil)
        notific.addObserver(self, selector: #selector(self.RequestErrorNotificationRecived(_:)), name: _RequestErrorNotificationReceived.not, object: nil)
    }
    
    func unregisterReceivers()
    {
        notific.removeObserver(self, name: _ConnectionErrorNotification.not, object: nil)
        notific.removeObserver(self, name: _RequestErrorNotificationReceived.not, object: nil)
    }
    
    @objc func connectionErrorNotificationReceived(_ notification: NSNotification) {
        self.hideLoading()
        
        print("connectionErrorNotificationReceived")
        if let msg = notification.object as? String{
            self.showMessage(msg, type: .error,afterDelay : 3)
        }else if let err = notification.object as? Error{
            self.showMessage(err.localizedDescription, type: .error,afterDelay : 3)
        }
    }
    
    @objc func RequestErrorNotificationRecived(_ notification : NSNotification)
    {
        print("RequestErrorNotificationRecived")
        self.hideLoading()
        
        if let msg = notification.object as? String
        {
            self.showMessage(msg, type: .error,afterDelay : 3)
        }else if let err = notification.object as? Error{
            self.showMessage(err.localizedDescription, type: .error,afterDelay : 3)
        }
        
    }
    
    
    func showLoading(_ text : String! = nil){
        hud.indicatorView = JGProgressHUDIndeterminateIndicatorView.init()
        hud.textLabel.text = text
        hud.show(in: self.view, animated: false)
    }
    
    func hideLoading(){
        self.ref.endRefreshing()
        self.hud.dismiss(animated : false)
    }
    
    func showMessage(_ text : String, type : ProgressType, afterDelay : TimeInterval! = nil){
        if type == .toast || type == .error{
            KSToastView.ks_showToast(text, duration: 3)
        }else{
            hud = JGProgressHUD.init(style: JGProgressHUDStyle.dark)
            hud.textLabel.text = text
            if let delay = afterDelay{
                hud.dismiss(afterDelay: delay)
            }
            switch type{
            case .progress : hud.indicatorView = JGProgressHUDIndicatorView.init()
            case .success : hud.indicatorView = JGProgressHUDSuccessIndicatorView.init()
            case .error : hud.indicatorView = JGProgressHUDErrorIndicatorView.init()
            case .message : hud.indicatorView = nil
            default : break
            }
            
            hud.show(in: view)
        }
    }
    
    
    @objc func onTouch(){
        self.view.endEditing(true)
    }
    
    func sendError(_ err : Error){
        print("sendError : \(err.localizedDescription)")
        notific.post(name: _RequestErrorNotificationReceived.not, object: err)
    }
    
}

