//
//  CartVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/17/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit

class CartVC: BaseVC,UITableViewDelegate,UITableViewDataSource {
    
    @IBOutlet weak var tableView : UITableView!
    @IBOutlet weak var totalLbl : UILabel!
    @IBOutlet weak var calcStack : UIStackView!
    var currencyLocation : LocationInfo!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.currencyLocation = Provider.currentLocation
        
//        Communication.shared.locationInfo { (res) in
//            //            self.currencyId = res.CurrencyID.stringValue
//            self.currencyLocation = res
//        }
        
        self.navigationItem.title = "Cart".localized
        self.largeTitle()
        self.addLogoTop()
        self.ConfigSideMenu()
        self.addSideMenuButton()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        
        self.refreshTotal()
        self.tableView.reloadData()
    }
    
    
    override func setupViews() {
        self.tableView.dataSource = self
        self.tableView.delegate = self
        self.tableView.rowHeight = UITableView.automaticDimension
        self.tableView.estimatedRowHeight = 100
        self.tableView.tableFooterView = UIView()
        
        self.tableView.register(UINib.init(nibName: "CartCell", bundle: nil), forCellReuseIdentifier: "CartCell")
    }
    
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return Provider.Cart.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "CartCell", for: indexPath) as! CartCell
        cell.selectionStyle = .none
        cell.tag = indexPath.row
        cell.parentVC = self
        cell.cartItem = Provider.Cart[indexPath.row]
        return cell
    }
    
    func tableView(_ tableView: UITableView, commit editingStyle: UITableViewCell.EditingStyle, forRowAt indexPath: IndexPath) {
        print("EditingStyle")
    }
    
    func tableView(_ tableView: UITableView, canEditRowAt indexPath: IndexPath) -> Bool {
        return true
    }
    
    /*
    func tableView(_ tableView: UITableView, trailingSwipeActionsConfigurationForRowAt indexPath: IndexPath) -> UISwipeActionsConfiguration? {
        
        let deleteAction = UIContextualAction(style: .normal, title:  nil, handler: { (ac:UIContextualAction, view:UIView, success:(Bool) -> Void) in
            
            debugPrint("Delete tapped")
            
            success(true)
        })
        
        deleteAction.image = UIImage(named: "icon_delete.png")
        deleteAction.backgroundColor = UIColor.red
        
        return UISwipeActionsConfiguration(actions: [deleteAction])

    }*/
    
    /*
    func tableView(_ tableView: UITableView, editActionsForRowAt indexPath: IndexPath) -> [UITableViewRowAction]? {
        let deleteBtn = UITableViewRowAction.init(style: UITableViewRowAction.Style.destructive, title: "DELETE") { (ac, index) in
            
        }
        
        deleteBtn.setIcon(iconImage: #imageLiteral(resourceName: "baseline_delete_white_24pt"), backColor: UIColor.red, cellHeight: 40, iconSizePercentage: 100)
        
        return [deleteBtn]
    }*/
    
    func refreshTotal(){
        self.calcStack.isHidden = Provider.Cart.isEmpty

        var total : Double = 0
        
        for i in Provider.Cart{
            if let d = Double.init(i.Price){
                total += d * Double(i.QTY)
            }
        }
        
        self.totalLbl.text = "\(total)" + " " + Provider.currentLocation.symbol
        
        if Provider.Cart.isEmpty{
            self.tableView.setEmptyView(title: "You don't have any items in Cart".localized, message: "", messageImage: #imageLiteral(resourceName: "tabbar-card"))
        }else{
            self.tableView.restore()
        }
    }
    
    @IBAction func calcAction(){
        var products = [String]()
        var QTYs = [Int]()
        var Colors = [Int]()

        for i in Provider.Cart{
            products.append(i.ID)
            QTYs.append(i.QTY)
            Colors.append(i.Color)
        }
        
        if User.isRegistered(){
            
            let alert1 = UIAlertController.init(title: "Do you want to use a promotion code?".localized, message: nil, preferredStyle: UIAlertController.Style.alert)
            alert1.addAction(UIAlertAction.init(title: "NO".localized, style: UIAlertAction.Style.default, handler: { (ac) in
                self.showLoading()
                Communication.shared.billRegistered(Products: products, QTYs: QTYs,Colors : Colors, Currency: self.currencyLocation.CurrencyID.stringValue, Customer: User.getID()) { (res) in
                    self.hideLoading()
                    
                    let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProceedPopupVC") as! ProceedPopupVC
                    vc.modalPresentationStyle = .overCurrentContext
                    vc.modalTransitionStyle = .crossDissolve
                    vc.parentVC = self
                    vc.products = products
                    vc.QTYs = QTYs
                    vc.Colors = Colors
                    vc.currencyLocation = self.currencyLocation
                    vc.res = res
                    self.present(vc, animated: true, completion: nil)
                    
                    //let alert = UIAlertController.init(title: "Total Price", message: res, preferredStyle: UIAlertController.Style.alert)
                    //alert.addAction(UIAlertAction.init(title: "OK", style: UIAlertAction.Style.default, handler: nil))
                    //self.present(alert, animated: true, completion: nil)
                }
            }))
            alert1.addAction(UIAlertAction.init(title: "YES".localized, style: UIAlertAction.Style.default, handler: { (ac) in
                let vc = self.storyboard?.instantiateViewController(withIdentifier: "PromotionUseVC") as! PromotionUseVC
                vc.modalPresentationStyle = .overCurrentContext
                vc.modalTransitionStyle = .crossDissolve
                vc.parentVC = self
                vc.products = products
                vc.QTYs = QTYs
                vc.Colors = Colors
                vc.currencyLocation = self.currencyLocation
                self.present(vc, animated: true, completion: nil)
            }))
            
            self.present(alert1, animated: true, completion: nil)
            
        }else{
            self.showLoading()
            Communication.shared.bill(Products: products, QTYs: QTYs,Colors : Colors, Currency: self.currencyLocation.CurrencyID.stringValue) { (res) in
                self.hideLoading()
                let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProceedPopupVC") as! ProceedPopupVC
                vc.parentVC = self
                vc.modalPresentationStyle = .overCurrentContext
                vc.modalTransitionStyle = .crossDissolve
                vc.products = products
                vc.QTYs = QTYs
                vc.Colors = Colors
                vc.currencyLocation = self.currencyLocation
                vc.res = res
                self.present(vc, animated: true, completion: nil)
            }
        }
    }
    
    func deleteAt(_ index : Int){
        Provider.Cart.remove(at: index)
        self.refreshTotal()
        Provider.tabBar?.refreshCart()
    }
    
    //    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
    //        return view.frame.width / 5
    //    }
    
}

extension CartVC  {
    
    @available(iOS 11.0, *)
    func tableView(_ tableView: UITableView, trailingSwipeActionsConfigurationForRowAt indexPath: IndexPath) -> UISwipeActionsConfiguration? {
        
        let deleteAction = UIContextualAction(style: .destructive, title:  nil, handler: { (ac:UIContextualAction, view:UIView, success:(Bool) -> Void) in
            
            debugPrint("Delete tapped")

            success(true)
            self.deleteAt(indexPath.row)
        })
        
        deleteAction.image = #imageLiteral(resourceName: "baseline_delete_white_24pt")
        deleteAction.backgroundColor = UIColor.red
        
        return UISwipeActionsConfiguration(actions: [deleteAction])
    }

}

extension UITableViewRowAction {
    
    func setIcon(iconImage: UIImage, backColor: UIColor, cellHeight: CGFloat, iconSizePercentage: CGFloat)
    {
        let iconHeight = cellHeight * iconSizePercentage
        let margin = (cellHeight - iconHeight) / 2 as CGFloat
        
        UIGraphicsBeginImageContextWithOptions(CGSize(width: cellHeight, height: cellHeight), false, 0)
        let context = UIGraphicsGetCurrentContext()
        
        backColor.setFill()
        context!.fill(CGRect(x:0, y:0, width:cellHeight, height:cellHeight))
        
        iconImage.draw(in: CGRect(x: margin, y: margin, width: iconHeight, height: iconHeight))
        
        let actionImage = UIGraphicsGetImageFromCurrentImageContext();
        UIGraphicsEndImageContext();
        
        self.backgroundColor = UIColor.init(patternImage: actionImage!)
    }
}
