//
//  CategoriesBaseVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/11/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit

class CategoriesBaseVC: BaseVC, UITableViewDelegate,UITableViewDataSource {

    @IBOutlet weak var tableView : UITableView!
    
    var categories = [CategoryObj]()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        self.navigationItem.title = "Categories".localized
        self.largeTitle()
        self.addLogoTop()
        getData()
    }
    
//    override func viewWillAppear(_ animated: Bool) {
//        super.viewWillAppear(true)
//        
//        self.navigationController?.setNavigationBarHidden(false, animated: false)
//        self.navigationController?.isNavigationBarHidden = false
//    }

    
    override func setupViews() {
        tableView.rowHeight = UITableView.automaticDimension
        tableView.estimatedRowHeight = 300
        tableView.delegate = self
        tableView.dataSource = self
        tableView.tableFooterView = UIView.init()
        tableView.register(UINib.init(nibName: "CategoriesCell", bundle: nil), forCellReuseIdentifier: "CategoriesCell")
    }
    
    override func getRefreshing() {
        Communication.shared.categories { (res) in
            self.hideLoading()
            
            self.categories = CategoryObj.loadNeasted(res, i: 0)
            self.tableView.reloadData()
        }
    }
    
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return self.categories.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "CategoriesCell", for: indexPath) as! CategoriesCell
        cell.selectionStyle = .none
        cell.cat = self.categories[indexPath.row]
        cell.parentVC = self
        return cell
    }
    

}
