//
//  ChangePasswordVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/17/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit
import PasswordTextField

class ChangePasswordVC: BaseVC {
    
    @IBOutlet weak var tfOld : PasswordTextField!
    @IBOutlet weak var tfNew : PasswordTextField!
    @IBOutlet weak var tfNew2 : PasswordTextField!
    @IBOutlet weak var vv : UIView!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.vv.addGestureRecognizer(UITapGestureRecognizer.init(target: self, action: #selector(self.dissmiss)))
    }
    
    @IBAction func submitAction(){
        let old = tfOld.text!
        let new = tfNew.text!
        let new2 = tfNew2.text!
        
        if old.isEmpty ||
            new.isEmpty ||
            new2.isEmpty{
            self.showMessage("Please enter all fields".localized, type: .toast)
            return
        }
        
        if new != new2{
            self.showMessage("Passwords don't match".localized, type: .toast)
            return
        }
        
        self.showLoading()
        Communication.shared.changePassword(OldPassword: old, NewPassword: new) { (res) in
            self.hideLoading()
            self.showMessage("Your password has been changed".localized, type: .toast)
            self.dismiss(animated: true, completion: nil)
        }
        
    }
    
    
    override func onTouch() {
        
    }
    
}
