//
//  ContactusVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/17/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit

class ContactusVC: BaseVC {
    
    @IBOutlet weak var tfName : UITextField!
    @IBOutlet weak var tfEmail : UITextField!
    @IBOutlet weak var tvMessage : UITextView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        
        self.navigationItem.title = "Contact Us".localized
        self.largeTitle()
        self.addLogoTop()
        self.ConfigSideMenu()
        self.addSideMenuButton()
    }
    
    
    @IBAction func sendAction(){
        let name = self.tfName.text!
        let email = self.tfEmail.text!
        let message = self.tvMessage.text!
        
        
        self.showLoading()
        Communication.shared.contactUs(Name: name, Email: email, Message: message) { (res) in
            self.hideLoading()
            self.showMessage("Your message has been sent successfully".localized, type: .toast)
            self.navigationController?.popViewController(animated: true)
        }
        
    }
    
    
}
