//
//  ElanDetailsPopupVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/17/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit

class ElanDetailsPopupVC: BaseVC {
    
    @IBOutlet weak var vv : UIView!
    
    @IBOutlet weak var stackVistor : UIStackView!
    
    @IBOutlet weak var titleLbl : UILabel!
    @IBOutlet weak var advertiserLbl : UILabel!
    @IBOutlet weak var contentLbl : UILabel!
    
    @IBOutlet weak var tfName : UITextField!
    @IBOutlet weak var tfEmail : UITextField!
    @IBOutlet weak var tfMobile : UITextField!
    var elan : Elan!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.vv.addGestureRecognizer(UITapGestureRecognizer.init(target: self, action: #selector(self.dissmiss)))
        
        self.titleLbl.text = elan.Title
        self.advertiserLbl.text = elan.Name
        self.contentLbl.text = elan.Content
        
        stackVistor.isHidden = User.isRegistered()
    }
    
    
    @IBAction func shareAction(){
        let imgV = UIImageView()
        Provider.sd_setImage(imgV, urlString: elan.ImageURL)
        guard let imgg = imgV.image else {
            return
        }
        let imageToShare = [ imgg ]
        let activityViewController = UIActivityViewController(activityItems: imageToShare, applicationActivities: nil)
        activityViewController.popoverPresentationController?.sourceView = self.view
        activityViewController.excludedActivityTypes = [  ]
        self.present(activityViewController, animated: true, completion: nil)
    }
    
    
    @IBAction func getAD(){
        
        if User.isRegistered(){
            self.showLoading()
            Communication.shared.takeElanRegistered(Elan: elan.ID.stringValue, callback: { (res) in
                self.hideLoading()
                self.showMessage("Elan has been sent".localized, type: .toast)
                self.dismiss(animated: true, completion: nil)
            })
        }else{
            let name = self.tfName.text!
            let mobile = self.tfMobile.text!
            let email = self.tfEmail.text!
            
            if name.isEmpty || mobile.isEmpty || email.isEmpty{
                self.showMessage("Please enter all fields".localized, type: .toast)
                return
            }else  if !email.isValidEmail(){
                self.showMessage("The Email is not valid".localized, type: .toast)
                return
            }else{
                self.showLoading()
                Communication.shared.takeElanUnRegistered(Elan: self.elan.ID.stringValue, Name: name, Email: email, Tel: mobile) { (res) in
                    self.hideLoading()
                    self.showMessage("Elan has been sent".localized, type: .toast)
                    self.dismiss(animated: true, completion: nil)
                }
            }
        }
    }
    
    
}
