//
//  FavoritesVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/13/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit

class FavoritesVC: BaseVC ,UICollectionViewDelegate, UICollectionViewDataSource,UICollectionViewDelegateFlowLayout {
    
    @IBOutlet weak var collectionView : UICollectionView!
    
    var products = [Product]()

    override func viewDidLoad() {
        super.viewDidLoad()

        getData()
    }
    
    override func getRefreshing() {
        if User.isRegistered(){
            Communication.shared.myWish { (res) in
                self.hideLoading()
                self.products = res
                self.collectionView.reloadData()
            }
        }else{
            if let img = UIImage.init(named: "logo2"){
                let btn = UIButton()
                btn.setTitle("LOGIN".localized, for: .normal)
                btn.addTarget(self, action: #selector(self.goToLogin), for: .touchUpInside)
                self.collectionView.setEmptyView(title: "You're not logged in".localized, message: "", messageImage: img, btn: btn)
            }
        }
    }
    
    
    override func setupViews() {
        self.collectionView.dataSource = self
        self.collectionView.delegate = self
        if User.isRegistered(){
            self.collectionView.addSubview(ref)
        }
        self.navigationItem.title = "Favorite".localized
        self.largeTitle()
        self.addLogoTop()
        self.ConfigSideMenu()
        self.addSideMenuButton()
    }
    
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return products.count
    }
    
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "cell", for: indexPath) as! ProductCell
        cell.parentVC2 = self
        cell.productWishlist = self.products[indexPath.row]
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        
        return CGSize.init(width: collectionView.frame.width, height: 110)
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        if let cell = collectionView.cellForItem(at: indexPath) as? ProductCell{
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductVC") as! ProductVC
            vc.cc_setZoomTransition(originalView: cell.img)
            vc.product = self.products[indexPath.row]
            self.parent?.present(vc, animated: true, completion: nil)
        }
    }
    


}
