//
//  HomeVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/9/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit
import FSPagerView

class HomeVC: BaseTVC {
    
    @IBOutlet weak var sliderView : FSPagerView!
    @IBOutlet weak var pageControl : FlexiblePageControl!
    @IBOutlet weak var collectionView1 : UICollectionView!
    @IBOutlet weak var collectionView2 : UICollectionView!
    @IBOutlet weak var collectionView3 : UICollectionView!
    @IBOutlet weak var collectionView4 : UICollectionView!
    
    @IBOutlet weak var collectionViewTodayHotDealsHeight : NSLayoutConstraint!
    @IBOutlet weak var collectionViewNewArrivalsHeight : NSLayoutConstraint!
    
    
    var sliderItems = [SliderItem]()
    var todayTrendingItems = [Product]()
    var sellers = [Seller]()
    var todayHotDeals = [Today]()
    var newArrivals = [Product]()
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        
        self.showLoading()
        self.getData()
         }
    
//    override func viewWillAppear(_ animated: Bool) {
//        super.viewWillAppear(true)
//        
//        self.navigationController?.setNavigationBarHidden(false, animated: false)
//        self.navigationController?.isNavigationBarHidden = false
//    }
    
    override func setupViews() {
        tableView.rowHeight = UITableView.automaticDimension
        tableView.estimatedRowHeight = 300
        tableView.separatorStyle = .none
        self.tableView.addSubview(ref)
        
        self.sliderView.isInfinite = true
        self.sliderView.register(UINib.init(nibName: "SliderHomeCell", bundle: nil), forCellWithReuseIdentifier: "cell")
        collectionView1.register(UINib.init(nibName: "TodayHomeCell", bundle: nil), forCellWithReuseIdentifier: "cell")
        collectionView2.register(UINib.init(nibName: "BestSellerHomeCell", bundle: nil), forCellWithReuseIdentifier: "cell")
        collectionView3.register(UINib.init(nibName: "TodayHotDealsHomeCell", bundle: nil), forCellWithReuseIdentifier: "cell")
        collectionView4.register(UINib.init(nibName: "HotDealsCell", bundle: nil), forCellWithReuseIdentifier: "cell")
        
        collectionView1.contentInset = UIEdgeInsets(top: 0, left: 20, bottom: 0, right: 0)
        
        self.hideLargeTitle()
        self.addLogoTop()
        self.ConfigSideMenu()
        self.addSideMenuButton()
    }
    
    override func getRefreshing() {
        Communication.shared.getSlider { (res) in
            self.sliderItems = res
            self.pageControl.numberOfPages = res.count
            self.sliderView.reloadData()
            self.sliderView.automaticSlidingInterval = 5.0

            
            Communication.shared.getTodayTrending { (res) in
                self.todayTrendingItems = res
                self.collectionView1.reloadData()
                
                Communication.shared.getBestSeller { (res) in
                    self.sellers = res
                    self.collectionView2.reloadData()
                }
                
                Communication.shared.getTodayHotDeals { (res) in
                    self.todayHotDeals = res
                    
                    self.collectionView3.superview?.layoutIfNeeded()
                    self.collectionView3.reloadData()
                    self.collectionViewTodayHotDealsHeight.constant = self.collectionView3.collectionViewLayout.collectionViewContentSize.height
                }
                
                Communication.shared.getNewArrivals { (res) in
                    self.newArrivals = res
                    
                    self.collectionView4.superview?.layoutIfNeeded()
                    self.collectionView4.reloadData()
                    self.collectionViewNewArrivalsHeight.constant = self.collectionView4.collectionViewLayout.collectionViewContentSize.height
                    
                    //self.tableView.reloadData()
                    self.tableView.beginUpdates()
                    self.tableView.endUpdates()
                    self.hideLoading()
                }
            }
        }
    }
    
    
    @IBAction func openSearchVC(){
        Provider.tabBar?.selectedViewController = Provider.tabBar?.viewControllers?[3]
    }
    
    
}

extension HomeVC : UICollectionViewDelegate,UICollectionViewDataSource,UICollectionViewDelegateFlowLayout{
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        switch collectionView {
        case collectionView1: return todayTrendingItems.count
        case collectionView2: return sellers.count
        case collectionView3 : return todayHotDeals.count
        case collectionView4: return newArrivals.count
        default:  return 0
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        
        switch collectionView {
        case collectionView1:
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "cell", for: indexPath) as! TodayHomeCell
            cell.product = self.todayTrendingItems[indexPath.row]
            return cell
        case collectionView2:
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "cell", for: indexPath) as! BestSellerHomeCell
            cell.product = self.sellers[indexPath.row].Product.first
            return cell
        case collectionView3:
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "cell", for: indexPath) as! TodayHotDealsHomeCell
            cell.today = self.todayHotDeals[indexPath.row]
            return cell
        case collectionView4:
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "cell", for: indexPath) as! HotDealsCell
            cell.product = self.newArrivals[indexPath.row]
            return cell
        default:
            return UICollectionViewCell.init()
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        switch collectionView {
        case collectionView1:
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductVC") as! ProductVC
            vc.product = self.todayTrendingItems[indexPath.row]
            if let cell = collectionView.cellForItem(at: indexPath) {
                vc.cc_setZoomTransition(originalView: cell)
            }
            self.present(vc, animated: true, completion: nil)
        case collectionView2:
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductVC") as! ProductVC
            vc.product = self.sellers[indexPath.row].Product.first
            if let cell = collectionView.cellForItem(at: indexPath) {
                vc.cc_setZoomTransition(originalView: cell)
            }
            self.present(vc, animated: true, completion: nil)
        case collectionView3:
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductVC") as! ProductVC
            vc.product = self.todayHotDeals[indexPath.row].Product
            if let cell = collectionView.cellForItem(at: indexPath) {
                vc.cc_setZoomTransition(originalView: cell)
            }
            self.present(vc, animated: true, completion: nil)
        case collectionView4:
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductVC") as! ProductVC
            vc.product = self.newArrivals[indexPath.row]
            if let cell = collectionView.cellForItem(at: indexPath) {
                vc.cc_setZoomTransition(originalView: cell)
            }
            self.present(vc, animated: true, completion: nil)
        default:
            break
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        let w = collectionView.frame.width
        let h = collectionView.frame.height
        
        switch collectionView {
        case collectionView1:
            return CGSize(width: w / 3, height: h)
        case collectionView2:
            return (indexPath.row == 0) ? CGSize(width: w / 2, height: h) : CGSize(width: w / 4, height: h / 2)
        case collectionView3:
            return CGSize(width: w, height: 100)
        case collectionView4:
            return CGSize(width: w / 2, height: 100)
        default:
            return CGSize.init(width: 0, height: 0)
        }
    }
    

    
}


extension HomeVC{
    
    override func tableView(_ tableView: UITableView, willDisplay cell: UITableViewCell, forRowAt indexPath: IndexPath) {
        cell.selectionStyle = .none
    }
    
    
    override func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
//        if indexPath.row == 3{
//            return CGFloat(self.todayHotDeals.count * 100)
//        }
//        if indexPath.row == 4{
//            let n : Double = Double(self.newArrivals.count) / 2.0
//            let w = tableView.frame.width / 2
//            return CGFloat(w) * CGFloat(n)
//        }
//
        return UITableView.automaticDimension
    }
    
    
}

extension HomeVC : FSPagerViewDelegate, FSPagerViewDataSource{
    
    public func numberOfItems(in pagerView: FSPagerView) -> Int {
        return self.sliderItems.count
    }
    
    public func pagerView(_ pagerView: FSPagerView, cellForItemAt index: Int) -> FSPagerViewCell {
        let cell = pagerView.dequeueReusableCell(withReuseIdentifier: "cell", at: index) as! SliderHomeCell
        cell.sliderItem = self.sliderItems[index]
        return cell
    }
    
//    func pagerViewWillEndDragging(_ pagerView: FSPagerView, targetIndex: Int) {
//        self.pageControl.setCurrentPage(at: targetIndex, animated: true)
//    }
    
    func pagerViewDidScroll(_ pagerView: FSPagerView) {
        self.pageControl.setCurrentPage(at: Int(pagerView.scrollOffset.rounded()), animated: true)
    }
    
}
