//
//  HotDealsVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/13/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit

class HotDealsVC: BaseVC, UICollectionViewDelegate, UICollectionViewDataSource,UICollectionViewDelegateFlowLayout {
    
    @IBOutlet weak var collectionView : UICollectionView!
    
    var todays = [Today]()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        getData()
    }
    
    override func getRefreshing() {
        Communication.shared.getTodayHotDeals { (res) in
            self.hideLoading()
            self.todays = res
            self.collectionView.reloadData()
        }
    }
    
    override func setupViews() {
        collectionView.delegate = self
        collectionView.dataSource = self
        collectionView.register(UINib.init(nibName: "TodayCell", bundle: nil), forCellWithReuseIdentifier: "cell")
        
        self.navigationItem.title = "Hot Deals".localized
        self.largeTitle()
        self.addLogoTop()
        
    }
    
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return todays.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "cell", for: indexPath) as! TodayCell
        cell.today = self.todays[indexPath.item]
        return cell
    }
    
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        return CGSize.init(width: collectionView.bounds.width, height: 150)
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        let alert = UIAlertController.init(title: self.todays[indexPath.item].Content, message: nil, preferredStyle: UIAlertController.Style.alert)
        alert.addAction(UIAlertAction.init(title: "Open details".localized, style: UIAlertAction.Style.default, handler: { (ac) in
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductVC") as! ProductVC
            vc.product = self.todays[indexPath.item].Product
            vc.modalPresentationStyle = .fullScreen
            self.present(vc, animated: true, completion: nil)
        }))
        alert.addAction(UIAlertAction.init(title: "CANCEL".localized, style: UIAlertAction.Style.cancel, handler: nil))
        alert.addAction(UIAlertAction.init(title: "Share".localized, style: UIAlertAction.Style.default, handler: { (ac) in
            let imgV = UIImageView()
            Provider.sd_setImage(imgV, urlString: self.todays[indexPath.item].ImageURL)
            guard let imgg = imgV.image else {
                return
            }
            
            let imageToShare = [ imgg ]
            let activityViewController = UIActivityViewController(activityItems: imageToShare, applicationActivities: nil)
            activityViewController.popoverPresentationController?.sourceView = self.view
            activityViewController.excludedActivityTypes = [  ]
            self.present(activityViewController, animated: true, completion: nil)
        }))
        DispatchQueue.main.async {
            self.present(alert, animated: true, completion: nil)
        }
        
    }
    
    
    
    
}
