//
//  LoginVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/10/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit
import PasswordTextField
import Alamofire
import SwiftyJSON

class LoginVC: BaseVC {

    @IBOutlet weak var tfEmail : UITextField!
    @IBOutlet weak var tfPassword : PasswordTextField!

    @IBOutlet weak var emailBottomVV : UIView!
    @IBOutlet weak var passwordBottomVV : UIView!
    
    override func viewDidLoad() {
        super.viewDidLoad()

        tfEmail.delegate = self
        tfPassword.delegate = self
    }
    
//    override func viewWillAppear(_ animated: Bool) {
//        super.viewWillAppear(true)
//        self.navigationController?.setNavigationBarHidden(true, animated: false)
//        self.navigationController?.isNavigationBarHidden = true
//    }

    
    @IBAction func signupAction(){
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "SignupVC") as! SignupVC
        vc.modalTransitionStyle = .crossDissolve
        vc.modalPresentationStyle = .fullScreen
        self.present(vc, animated: true, completion: nil)
//        self.navigationController?.pushViewController(vc, animated: true)
    }
    
    @IBAction func forgotAction(){
        
        let alert = UIAlertController(title: "Forget Password".localized, message: "Please Enter Your Email".localized, preferredStyle: UIAlertController.Style.alert)
        let okAction = UIAlertAction(title: "OK".localized, style: .default) { (alertAction) in
            let textField = alert.textFields![0] as UITextField

            let params : [String : String] = ["SystemPasscode" : SystemPasscode , "Email" : textField.text!]
            self.getDataJsonForgetPassword(params: params)
            alert.textFields![0].text = ""
        }
        let cancelAction = UIAlertAction(title: "CANCEL".localized, style: .default) { (alertAction) in
            print("cancel tapped")
        }
        alert.addTextField { (textField) in
            textField.placeholder = "Enter your Email".localized
            textField.borderStyle = .none
        }
        
        alert.addAction(okAction)
        alert.addAction(cancelAction)
        
        self.present(alert, animated: true, completion: nil)
    }
    func getDataJsonForgetPassword(params : [String : String]){
        showLoading()
        let url : String = "\(Communication.shared.baseURL)\(Communication.shared.forgetURL)"
        Alamofire.request(url, method: .post, parameters: params).responseJSON { response in
            if response.result.isSuccess {
                print("Success")
                let forgetPasswordJson : JSON = JSON(response.result.value!)
                
                let message = forgetPasswordJson["ErrorMessage"].stringValue
                if message == ""
                {
                    print("Json file : \(forgetPasswordJson)")
                    
                }else
                {
                    self.showMessage(message, type: .toast)
                }
                self.hideLoading()
                //print(self.dataArray[0].id)
                
            }else {
                self.hideLoading()
                self.showMessage("Failed".localized, type: .toast)
            }
        }
    }

    
    @IBAction func loginAction(){
        let email = tfEmail.text!
        let password = tfPassword.text!
        
        guard !email.isEmpty && !password.isEmpty else {
            self.showMessage("Please enter email and password".localized, type: .toast)
            return
        }
        
        guard email.isValidEmail() else {
            self.showMessage("The Email is not valid".localized, type: .toast)
            return
        }
        
        
        self.showLoading()
        Communication.shared.login(email: email, password: password) { (res) in
            self.hideLoading()
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "TabBarVC") as! TabBarVC
//            self.navigationController?.pushViewController(vc, animated: true)
            vc.modalTransitionStyle = .crossDissolve
            vc.modalPresentationStyle = .fullScreen
            self.present(vc, animated: true, completion: nil)

        }
        
    }
    
    
    func textFieldDidBeginEditing(_ textField: UITextField) {
        tfEmail.tintColor = (textField == tfEmail) ? Theme.Color.blue : Theme.Color.gray
        tfPassword.tintColor = (textField == tfPassword) ? Theme.Color.blue : Theme.Color.gray
        emailBottomVV.backgroundColor = tfEmail.tintColor
        passwordBottomVV.backgroundColor = tfPassword.tintColor
    }
    
    func textFieldDidEndEditing(_ textField: UITextField) {
        tfEmail.tintColor = Theme.Color.gray
        tfPassword.tintColor = Theme.Color.gray
        emailBottomVV.backgroundColor = Theme.Color.gray
        passwordBottomVV.backgroundColor = Theme.Color.gray
    }
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        textField.resignFirstResponder()
        return true
    }
    
}
