//
//  MyOrdersVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/22/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit
import SideMenu

class MyOrdersVC: BaseVC, UITableViewDelegate, UITableViewDataSource {
    
    @IBOutlet weak var tableView : UITableView!
    
    var orders = [Order]()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        if User.isRegistered(){
            getData()
        }else{
            if let img = UIImage.init(named: "logo2"){
                let btn = UIButton()
                btn.setTitle("LOGIN".localized, for: .normal)
                btn.addTarget(self, action: #selector(self.goToLogin), for: .touchUpInside)
                self.tableView.setEmptyView(title: "You're not logged in".localized, message: "", messageImage: img, btn: btn)
            }
        }
        
    }
    
    override func setupViews() {
        self.tableView.dataSource = self
        self.tableView.delegate = self
        self.tableView.rowHeight = UITableView.automaticDimension
        self.tableView.estimatedRowHeight = 100
        self.tableView.tableFooterView = UIView()
        self.tableView.separatorStyle = .none
        
        self.navigationItem.title = "My Orders".localized
        self.largeTitle()
        self.addLogoTop()
        self.ConfigSideMenu()
        self.addSideMenuButton()

    }
    
    override func getRefreshing() {
        Communication.shared.getOrders { (res) in
            self.hideLoading()
            
            self.orders = res
            self.tableView.reloadData()
        }
    }
    
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return orders.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "cell", for: indexPath) as! OrderCell
        cell.selectionStyle = .none
        cell.tag = indexPath.row
        cell.parentVC = self
        cell.order = self.orders[indexPath.row]
        
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
    }
    
    
    func openDetails(_ index : Int){
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "OrderDetailsVC") as! OrderDetailsVC
        vc.order = self.orders[index]
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
    func openTrack(_ index : Int){
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "OrderTrackVC") as! OrderTrackVC
        vc.order = self.orders[index]
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
    
}
