//
//  OrderDetailsVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/22/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit

class OrderDetailsVC: BaseVC, UITableViewDelegate, UITableViewDataSource {
    
    @IBOutlet weak var tableView : UITableView!
    var order : Order!
    
    override func viewDidLoad() {
        super.viewDidLoad()
     
        self.hideLargeTitle()
    }
    
    override func setupViews() {
        self.title = order.OrderNumber
        self.tableView.dataSource = self
        self.tableView.delegate = self
        self.tableView.rowHeight = UITableView.automaticDimension
        self.tableView.estimatedRowHeight = 100
        self.tableView.tableFooterView = UIView()
        self.tableView.separatorStyle = .none
        self.tableView.reloadData()
    }
    
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return order.InvoiceDetails.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "cell", for: indexPath) as! InvoiceDetailsCell
        cell.selectionStyle = .none
        
        cell.invoiceDetailsObj = self.order.InvoiceDetails[indexPath.row]
        
        return cell
    }
    
    
    
    
}
