//
//  PaymentWebVC.swift
//  We1l
//
//  Created by Yahya Tabba on 4/27/20.
//  Copyright © 2020 Yahya Tabba. All rights reserved.
//

import UIKit
import WebKit

class PaymentWebVC: BaseVC,WKUIDelegate, WKNavigationDelegate {
    
    var webView = WKWebView()
    var urlString : String!
    var parentVC : CheckOutTVC?
    
    override func viewDidLoad() {
        super.viewDidLoad()
                
//        self.navigationItem.leftBarButtonItem = UIBarButtonItem.init(barButtonSystemItem: .stop, target: self, action: #selector(self.dissmiss))
        
        self.navigationItem.leftBarButtonItem = UIBarButtonItem.init()
        
        self.title = "Payment".localized
        
        let source: String = "var meta = document.createElement('meta');" +
            "meta.name = 'viewport';" +
            "meta.content = 'width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no';" +
            "var head = document.getElementsByTagName('head')[0];" +
            "head.appendChild(meta);"

        let script: WKUserScript = WKUserScript(source: source, injectionTime: .atDocumentEnd, forMainFrameOnly: true)
        let userContentController: WKUserContentController = WKUserContentController()
        let conf = WKWebViewConfiguration()
        conf.userContentController = userContentController
        userContentController.addUserScript(script)
        self.webView = WKWebView(frame: CGRect.zero, configuration: conf)
        
        self.view = webView
        self.webView.uiDelegate = self
        self.webView.navigationDelegate = self

        if let urlString = urlString{
            if let url = URL(string: urlString) {
                let request = URLRequest(url: url)
                self.showLoading()
                self.webView.load(request)
            }
        }
        
    }
    
    
    func webView(_ webView: WKWebView, decidePolicyFor navigationAction: WKNavigationAction, decisionHandler: @escaping (WKNavigationActionPolicy) -> Void) {
        print("#######")
        print(navigationAction.request.url?.absoluteString)
        
        if navigationAction.request.url?.absoluteString.contains("we1l.com") ?? false{
            self.showMessage("Your order has been sent successfully", type: .toast)
            
            self.dismiss(animated: true) {
                let vc = self.storyboard?.instantiateViewController(withIdentifier: "HomeVC") as! HomeVC
                self.parentVC?.navigationController?.pushViewController(vc, animated: true)
            }
            decisionHandler(.cancel)
        }else{
            decisionHandler(.allow)
        }
    }
    func webView(_ webView: WKWebView, didFinish navigation: WKNavigation!) {
        self.hideLoading()
        
        print("----------")
        print(webView.url?.absoluteString)
        print("----------")
    }
    
    
}
