//
//  ProceedPopupVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/17/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit

class ProceedPopupVC: BaseVC {
    
    @IBOutlet weak var vv : UIView!
    @IBOutlet weak var totalLbl : UILabel!
    
    var parentVC : CartVC?
    
    var products = [String]()
    var QTYs = [Int]()
    var Colors = [Int]()

    var currencyLocation : LocationInfo!
    var publicCode : String!
    var privateCode : String!
    var res = String()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.vv.addGestureRecognizer(UITapGestureRecognizer.init(target: self, action: #selector(self.dissmiss)))
        
        totalLbl.text = res + " " + currencyLocation.symbol
    }
    
    @IBAction func proceedAction(){
        
        self.dismiss(animated: true) {
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "CheckOutTVC") as! CheckOutTVC
            vc.products = self.products
            vc.QTYs = self.QTYs
            vc.Colors = self.Colors
            vc.currencyLocation = self.currencyLocation
            vc.publicCode = self.publicCode
            vc.privateCode = self.privateCode
            vc.res = self.res
            self.parentVC?.navigationController?.pushViewController(vc, animated: true)
        }
        
    }
    
}
