
//
//  ProductVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/16/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit
import FSPagerView

class ProductVC: BaseTVC,UICollectionViewDelegate,UICollectionViewDataSource,UICollectionViewDelegateFlowLayout,FSPagerViewDelegate,FSPagerViewDataSource {

    @IBOutlet weak var pagerView : FSPagerView!
    @IBOutlet weak var pageControl : FlexiblePageControl!
    @IBOutlet weak var collectionViewColors : UICollectionView!
    @IBOutlet weak var nameLbl : UILabel!
    @IBOutlet weak var brandLbl : UILabel!
    @IBOutlet weak var priceLbl : UILabel!
    @IBOutlet weak var contentLbl : UILabel!
    @IBOutlet weak var collectionViewMore : UICollectionView!

    
    @IBOutlet weak var favBtn : UIButton!
    @IBOutlet weak var shareBtn : UIButton!
    @IBOutlet weak var addToCartBtn : UIButton!


    var product : Product!
    var selectedColor : Color!
    var images = [String]()
    
    override func viewDidLoad() {
        super.viewDidLoad()

//        var safeAreaBottom: CGFloat = 0.0
//        if #available(iOS 11.0, *) {
//            safeAreaBottom = UIApplication.shared.keyWindow!.safeAreaInsets.bottom
//        }
//        tableView.contentInset = UIEdgeInsets(top: 0, left: 0, bottom: safeAreaBottom, right: 0.0)

        
        refreshData()
        getData()
    }
    
    override func getRefreshing() {
        Communication.shared.product(ID: self.product.ID.stringValue) { (res, res2) in
            self.hideLoading()
            
            self.product = res
            self.refreshData()
            self.tableView.beginUpdates()
            self.tableView.endUpdates()
//            self.tableView.reloadData()
        }
    }
    
    override func setupViews() {
        self.tableView.rowHeight = UITableView.automaticDimension
        self.tableView.estimatedRowHeight = 300.0
        
        self.pagerView.isInfinite = true
        self.pagerView.delegate = self
        self.pagerView.dataSource = self
        self.pagerView.register(UINib.init(nibName: "ProductImageCell", bundle: nil), forCellWithReuseIdentifier: "ProductImageCell")
        
        self.collectionViewColors.delegate = self
        self.collectionViewColors.dataSource = self
        self.collectionViewColors.register(UINib.init(nibName: "ColorCell", bundle: nil), forCellWithReuseIdentifier: "colorCell")
        
        
        self.collectionViewMore.delegate = self
        self.collectionViewMore.dataSource = self
        self.collectionViewMore.register(UINib.init(nibName: "MoreProductCell", bundle: nil), forCellWithReuseIdentifier: "MoreProductCell")
        self.collectionViewMore.register(UINib(nibName: "TodayHomeCell", bundle: nil), forCellWithReuseIdentifier: "TodayHomeCell")
        self.collectionViewMore.contentInset = UIEdgeInsets(top: 0, left: 20, bottom: 0, right: 0)
    }
    
    func refreshData(){
            self.collectionViewColors.reloadData()
        self.collectionViewMore.reloadData()
        
        if let selectedColor = selectedColor{
            if let c = self.product.Images.Color.first(where: {$0.ColorID.stringValue == selectedColor.ColorID.stringValue}){
                self.images = c.ProductImages
            }
        }else if self.product.Images != nil{
            self.images = self.product.Images.NoColor
        }
        
        self.pageControl.numberOfPages = self.images.count
        self.pagerView.reloadData()
        
        if product.Price != nil{
            self.priceLbl.text = product.Price.fromPrice + " " + Provider.currentLocation.symbol
        }else{
            self.priceLbl.text = ""
        }
        
        if let IsLiked = self.product.IsLiked{
            let img = IsLiked.Boolean ? #imageLiteral(resourceName: "baseline_favorite_black_24pt") : #imageLiteral(resourceName: "baseline_favorite_border_black_24pt")
            self.favBtn.setImage(img, for: UIControl.State.normal)
        }
        
        self.nameLbl.text = product.Name ?? ""
        self.brandLbl.text = product.BrandName ?? ""
        self.contentLbl.text = product.Content ?? ""
        
/*            self.priceBeforeLbl.isHidden = (product.PriceBeforeSale == nil)
            if let PriceBeforeSale = product.PriceBeforeSale{
                let attributedString = NSAttributedString(string: PriceBeforeSale.stringValue + " " + product.Symbol)
                let textRange = NSMakeRange(0, attributedString.length)
                let underlinedMessage = NSMutableAttributedString(attributedString: attributedString)
                underlinedMessage.addAttribute(NSAttributedString.Key.strikethroughStyle,
                                               value:NSUnderlineStyle.single.rawValue,
                                               range: textRange)
                self.priceBeforeLbl.attributedText = underlinedMessage
            }*/
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        if collectionView == collectionViewColors{
            self.selectedColor = (indexPath.row == 0) ? nil : self.product.Images.Color[indexPath.item - 1]
            refreshData()
        }else if collectionView == collectionViewMore{
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductVC") as! ProductVC
            vc.product = self.product.FromSameCategory[indexPath.row]
            self.show(vc, sender: nil)
        }
    }
    
    @IBAction func addToCartAction(){
        
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "QuantityVC") as! QuantityVC
        vc.modalPresentationStyle = .overCurrentContext
        vc.modalTransitionStyle = .crossDissolve
        vc.product = self.product
        vc.parentVC = self
        self.present(vc, animated: true, completion: nil)
        
    }
    
    
    @IBAction func favAction(){
        if self.product.IsLiked != nil{
            
            self.showLoading()
            if self.product.IsLiked.Boolean{
                Communication.shared.deleteWish(ProductID: self.product.ID.stringValue) { (res) in
                    self.getRefreshing()
                }
            }else{
                Communication.shared.addWish(ProductID: self.product.ID.stringValue) { (res) in
                    self.getRefreshing()
                }
            }
            
        }
    }
    
    @IBAction func shareAction(){
        /*let imgV = UIImageView()
        
        
        Provider.sd_setImage(imgV, urlString: parentVC.post.fullPath)
        
        guard let imgg = imgV.image else {
            return
        }
        
        let imageToShare = [ imgg ]
        let activityViewController = UIActivityViewController(activityItems: imageToShare, applicationActivities: nil)
        activityViewController.popoverPresentationController?.sourceView = self.view // so that iPads won't crash
        
        activityViewController.excludedActivityTypes = [  ]
        
        self.present(activityViewController, animated: true, completion: nil)*/
    }

    
    
    @IBAction func dismis(){
        self.dismiss(animated: true, completion: nil)
    }
    
    
    override func tableView(_ tableView: UITableView, willDisplay cell: UITableViewCell, forRowAt indexPath: IndexPath) {
        cell.selectionStyle = .none
    }
    
    override func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }
    
    func numberOfItems(in pagerView: FSPagerView) -> Int {
        return images.count
    }
    
    func pagerView(_ pagerView: FSPagerView, cellForItemAt index: Int) -> FSPagerViewCell {
        let cell = pagerView.dequeueReusableCell(withReuseIdentifier: "ProductImageCell", at: index) as! ProductImageCell
        cell.urlString = self.images[index]
        return cell
    }
    
    func pagerViewDidScroll(_ pagerView: FSPagerView) {
        self.pageControl.setCurrentPage(at: Int(pagerView.scrollOffset.rounded()), animated: true)
    }

    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        if collectionView == collectionViewColors{
            if let product = self.product{
                if let images = product.Images{
                    return images.Color.count + 1
                }
            }
            return 1
        }else{
            if let product = self.product{
                return product.FromSameCategory.count
            }
            return 0
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        if collectionView == self.collectionViewColors{
        if indexPath.row == 0{
//            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "cell", for: indexPath) as! ColorCell
//            cell.lbl.text = "No Color"
//            return cell
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "colorCell", for: indexPath) as! ColorCell
//            cell.clearColor = true
            cell.img.image = #imageLiteral(resourceName: "baseline_block_black_24pt").withRenderingMode(.alwaysTemplate)
            cell.img.tintColor = Theme.Color.orange
            return cell
        }else{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "colorCell", for: indexPath) as! ColorCell
            cell.color = self.product.Images.Color[indexPath.item - 1]
            return cell
        }
        }else{
//            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "MoreProductCell", for: indexPath) as! MoreProductCell
//            cell.product = self.product.FromSameCategory[indexPath.row]
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "TodayHomeCell", for: indexPath) as! TodayHomeCell
            cell.moreProduct = self.product.FromSameCategory[indexPath.row]
            return cell
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        if collectionView == collectionViewColors{
        let w = 50.0//indexPath.row == 0 ? 100 : 50.0
            return CGSize.init(width: w, height: 50.0)
        }else{
            return CGSize(width: collectionView.frame.width / 3, height: collectionView.frame.height)
        }
    }

    
    
    
}
