//
//  ProfileVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/17/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit
import SideMenu

class ProfileVC: BaseVC {
    
    @IBOutlet weak var img : UIImageView!
    @IBOutlet weak var nameLbl : UILabel!
    @IBOutlet weak var telLbl : UILabel!
    @IBOutlet weak var mobileLbl : UILabel!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.navigationItem.title = "Profile".localized
        self.largeTitle()
        self.addLogoTop()
        self.ConfigSideMenu()
        self.addSideMenuButton()


    }
    
    override func loadView() {
        super.loadView()

        if !User.isRegistered(){
            if let img = UIImage.init(named: "logo2"){
                let btn = UIButton()
                btn.setTitle("LOGIN".localized, for: .normal)
                btn.addTarget(self, action: #selector(self.goToLogin), for: .touchUpInside)
                let vv = self.view.empty(title: "You're not logged in".localized, message: "", messageImage: img, btn: btn)
                vv.backgroundColor = .white
                self.view = vv
            }
        }
    }
    
    
    override func setupViews() {        
        let me = User.getCurrentUser()
        self.nameLbl.text = me.Fullname
        self.telLbl.text = me.Phone
        self.mobileLbl.text = me.Mobile
        Provider.sd_setImage(self.img, urlString: me.ImageURL)
        
    }
    
    @IBAction func ChangePasswordAction(){
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "ChangePasswordVC") as! ChangePasswordVC
        vc.modalPresentationStyle = .overCurrentContext
        vc.modalTransitionStyle = .crossDissolve
        self.present(vc, animated: true, completion: nil)
    }
    
}
