//
//  QuantityVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/11/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//
import UIKit

class QuantityVC: BaseVC,UIPickerViewDelegate,UIPickerViewDataSource,UICollectionViewDelegate,UICollectionViewDataSource,UICollectionViewDelegateFlowLayout {
    
    @IBOutlet weak var vv : UIView!
    @IBOutlet weak var picker : UIPickerView!
    
    @IBOutlet weak var collectionViewColors : UICollectionView!
    @IBOutlet weak var colorsStack : UIStackView!
    
     var selectedColor : Color!


    var parentVC : ProductVC?
    var product : Product!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.vv.addGestureRecognizer(UITapGestureRecognizer.init(target: self, action: #selector(self.dissmiss)))
        
        picker.delegate = self
        picker.dataSource = self
        
        self.collectionViewColors.delegate = self
        self.collectionViewColors.dataSource = self
        self.collectionViewColors.register(UINib.init(nibName: "ColorCell", bundle: nil), forCellWithReuseIdentifier: "colorCell")
        
        self.colorsStack.isHidden = self.product.Images?.Color.isEmpty ?? true
    }
    
    
    @IBAction func addToCartAction(){
        if let product = self.parentVC?.product{
            if !self.product.Images.Color.isEmpty, self.selectedColor == nil{
                self.showMessage("Select Color".localized, type: .toast)
                return
            }
            
            let p = CartItem()
            p.ID = product.ID.stringValue
            p.Name = product.Name
            p.ImageURL = product.Images.NoColor.first
            p.Price = product.Price.stringValue
            p.QTY = self.picker.selectedRow(inComponent: 0) + 1
            p.Color = self.product.Images.Color.isEmpty ? 0 : self.selectedColor.ColorID.intValue
            p.ColorURL = self.product.Images.Color.isEmpty ? nil : self.selectedColor.ColorURL
            Provider.Cart.append(p)
            self.showMessage("Done".localized, type: .toast)
            self.dismiss(animated: true) {
//                self.parentVC?.navigationController?.popViewController(animated: true)
                self.parentVC?.dismiss(animated: true, completion: nil)
                Provider.tabBar?.refreshCart()
            }
        }
    }
    
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return self.product.Images?.Color.count ?? 0
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "colorCell", for: indexPath) as! ColorCell
        cell.color = self.product.Images.Color[indexPath.item]
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        return CGSize.init(width: 50, height: 50)
    }
    
    func collectionView(_ collectionView: UICollectionView, willDisplay cell: UICollectionViewCell, forItemAt indexPath: IndexPath) {
        
        let c = self.product.Images.Color[indexPath.item]
        
        if let selectedColor = self.selectedColor,
            c.ColorID.stringValue == selectedColor.ColorID.stringValue{
            cell.backgroundColor = Theme.Color.red
        }else{
            cell.backgroundColor = .clear
        }
        
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        self.selectedColor = self.product.Images.Color[indexPath.item]
        self.collectionViewColors.reloadData()
    }
    
    
    func numberOfComponents(in pickerView: UIPickerView) -> Int {
        return  1
    }
    
    func pickerView(_ pickerView: UIPickerView, attributedTitleForRow row: Int, forComponent component: Int) -> NSAttributedString? {
        return NSAttributedString.init(string: "\(row + 1)", attributes: [NSAttributedString.Key.font : Theme.Font.CairoRegular])
    }
    
    func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        return 100
    }
    
    func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String? {
        return "\(row + 1)"
    }
    
    
    
}
