//
//  SearchVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/11/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit
import SwiftyJSON
import Alamofire
import SDWebImage

class SearchVC: BaseVC, UICollectionViewDelegate,UICollectionViewDataSource,UICollectionViewDelegateFlowLayout {
    
    @IBOutlet weak var collectionView: UICollectionView!
    let searchController = UISearchController(searchResultsController: nil)
    
    
    var products = [Product]()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.addLogoTop()
        
    }
    
    override func setupViews() {
        collectionView.delegate = self
        collectionView.dataSource = self
        collectionView.register(UINib(nibName : "ProductCell" , bundle : nil), forCellWithReuseIdentifier: "productCell")

        
        setupSearchBar()
        self.ConfigSideMenu()
        self.addSideMenuButton()
        
    }
    
    func setupSearchBar()
    {
        
        if #available(iOS 11.0, *) {
            searchController.obscuresBackgroundDuringPresentation = false
            searchController.searchBar.placeholder = "Enter your search here..".localized
            navigationItem.hidesSearchBarWhenScrolling = false
            navigationItem.searchController = searchController
            definesPresentationContext = true
            searchController.searchBar.delegate = self
            DispatchQueue.main.async {
                self.searchController.searchBar.becomeFirstResponder()
            }
        } else {
            let searchBar = UISearchBar()
            searchBar.showsCancelButton = false
            searchBar.placeholder = "Enter your search here..".localized
            searchBar.delegate = self
            self.navigationItem.titleView = searchBar
            DispatchQueue.main.async {
                searchBar.becomeFirstResponder()
            }
        }
        
    }
    
    
    func searchBar(_ searchBar: UISearchBar, textDidChange searchText: String) {
        Communication.shared.search(Text: searchText) { (res) in
            self.products = res
            self.collectionView.reloadData()
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return self.products.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "productCell", for: indexPath) as! ProductCell
        cell.tag = indexPath.row
        cell.product = self.products[indexPath.row]
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        let height = self.view.bounds.height / 2
        let width = self.view.bounds.width / 2
        return CGSize.init(width: width, height: height)
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
//        let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductDetailsVC") as! ProductDetailsVC
//        vc.productId = self.products[indexPath.row].ID.stringValue
//        vc.product = self.products[indexPath.row]
//        self.navigationController?.pushViewController(vc, animated: true)
        if let cell = collectionView.cellForItem(at: indexPath) as? ProductCell{
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "ProductVC") as! ProductVC
            vc.cc_setZoomTransition(originalView: cell.img)
            vc.product = self.products[indexPath.row]
            self.parent?.present(vc, animated: true, completion: nil)
        }

    }
    
}

