//
//  SettingsTVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/22/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit

class SettingsTVC: BaseTVC {

    @IBOutlet weak var countryLbl : UILabel!
    @IBOutlet weak var langLbl : UILabel!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()

        self.navigationItem.title = "Settings".localized
        self.largeTitle()
        self.addLogoTop()
        self.ConfigSideMenu()
        self.addSideMenuButton()

        if Provider.currentLocation.symbol == nil || Provider.currentLocation.symbol.isEmpty{
            self.countryLbl.text = "AED"
        }else{
            self.countryLbl.text = Provider.currentLocation.symbol
        }
        
        langLbl.text = Local.getLanguageName()
    }
    
    override func setupViews() {
        self.tableView.dataSource = self
        self.tableView.delegate = self
        self.tableView.rowHeight = UITableView.automaticDimension
        self.tableView.estimatedRowHeight = 100
        self.tableView.tableFooterView = UIView()
        

    }
    
    override func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        switch (indexPath.section,indexPath.row) {
        case (0,0):
            getCurrencies()
        case (1,0):
            self.getLanguage()
        default:
            break
        }
    }
    
    override func tableView(_ tableView: UITableView, willDisplay cell: UITableViewCell, forRowAt indexPath: IndexPath) {
        cell.selectionStyle = .none
    }
    
    func getCurrencies(){
        
        self.showLoading()
        Communication.shared.currency { (res) in
            self.hideLoading()
            let alert = UIAlertController.init(title: "Select Currency", message: nil, preferredStyle: UIAlertController.Style.actionSheet)
            
            for i in res{
                alert.addAction(UIAlertAction.init(title: i.Name, style: .default, handler: { (res) in
                    Provider.currentLocation.CurrencyID = i.ID
                    Provider.currentLocation.symbol = i.Name
                    self.countryLbl.text = Provider.currentLocation.symbol
                }))
            }
            alert.addAction(UIAlertAction.init(title: "CANCEL".localized, style: .cancel, handler: nil))
            self.present(alert, animated: true, completion: nil)
        }
    }
    
    func getLanguage(){
        let alert = UIAlertController.init(title: "Select Language".localized, message: nil, preferredStyle: UIAlertController.Style.actionSheet)
        
        self.showLoading()
        Communication.shared.getLang { (res) in
            self.hideLoading()
            for i in res{
                alert.addAction(UIAlertAction.init(title: i.Name, style: .default, handler: { (ac) in
                    print(i.File)
                    self.setLanguage(i)
                }))
            }
            alert.addAction(UIAlertAction.init(title: "CANCEL".localized, style: .cancel, handler: nil))
            self.present(alert, animated: true, completion: nil)
        }
    }
    
    func setLanguage(_ lang : Lang){
        self.showLoading()
        Communication.shared.getLangFile(lang: lang) { (res) in
            self.hideLoading()
            AppDelegate.setupViews()
        }
    }
    
    override func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        if indexPath.section == 0{
            return 0
        }
        
        return 50
    }
    
    override func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        if section == 0{
            return 0
        }
        
        return 36
    }
    
    override func tableView(_ tableView: UITableView, titleForHeaderInSection section: Int) -> String? {
        if section == 0 {return "Country".localized;}
        if section == 1 {return "Language".localized;}
        return nil
    }
    

}
