//
//  SideMenuVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/11/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit

class SideMenuVC: BaseTVC {
    
    @IBOutlet weak var img : UIImageView!
    @IBOutlet weak var nameLbl :UILabel!
    @IBOutlet weak var numberlbl :UILabel!
    
    @IBOutlet weak var logLbl :UILabel!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        
        self.hideLargeTitle()
        
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(true)
        
        Communication.shared.getStoreCredit { (res) in
            self.numberlbl.text = User.getStoreCredit()
        }
        
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        
        logLbl.text = User.isRegistered() ? "Logout".localized : "LOGIN".localized
        nameLbl.text = User.getCurrentUser().Fullname ?? "We1l"
        numberlbl.text = User.isRegistered() ? User.getStoreCredit() : nil
        Provider.sd_setImage(self.img, urlString: User.getCurrentUser().ImageURL)
    }
    
    override func setupViews() {
        self.tableView.rowHeight = UITableView.automaticDimension
        self.tableView.estimatedRowHeight = 300
    }
    
    
    override func tableView(_ tableView: UITableView, willDisplay cell: UITableViewCell, forRowAt indexPath: IndexPath) {
        //        cell.accessoryType = indexPath.row == 0 ? .none : .disclosureIndicator
        let vv = UIView.init()
        vv.backgroundColor = Theme.Color.gray
        cell.selectedBackgroundView = vv
        //        cell.imageView?.tintColor = Theme.Color.orange
    }
    
    override func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
        
        switch indexPath.row {
        case 1:
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "HomeVC") as! HomeVC
            self.navigationController?.pushViewController(vc, animated: false)
        case 2:
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "CategoriesBaseVC") as! CategoriesBaseVC
            self.navigationController?.pushViewController(vc, animated: true)
        case 3:
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "HotDealsVC") as! HotDealsVC
            self.navigationController?.pushViewController(vc, animated: true)
        case 4:
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "ElanatVC") as! ElanatVC
            self.navigationController?.pushViewController(vc, animated: true)
        case 5:
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "PromotionsVC") as! PromotionsVC
            self.navigationController?.pushViewController(vc, animated: true)
        case 6:
            if Provider.tabBar?.selectedViewController != Provider.tabBar?.viewControllers?[1]{
                Provider.tabBar?.selectedViewController = Provider.tabBar?.viewControllers?[1]
                self.dismiss(animated: true, completion: nil)
            }else{
                Provider.tabBar?.selectedViewController = Provider.tabBar?.viewControllers?[1]
                let vc = self.storyboard?.instantiateViewController(withIdentifier: "FavoritesVC") as! FavoritesVC
                self.navigationController?.pushViewController(vc, animated: true)
            }
        case 7:
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "MyOrdersVC") as! MyOrdersVC
            self.navigationController?.pushViewController(vc, animated: true)
        case 8:
            self.alertTrack()
        case 9:
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "SettingsTVC") as! SettingsTVC
            self.navigationController?.pushViewController(vc, animated: true)
        case 10:
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "ContactusVC") as! ContactusVC
            self.navigationController?.pushViewController(vc, animated: true)
        case 11:
            if User.isRegistered(){
                Communication.shared.logout { (res) in
                    AppDelegate.setupViews()
//                    self.goToLogin()
                }
            }else{
                AppDelegate.setupViews()
//                self.goToLogin()
            }
        default:
            break
        }
    }
    
    func alertTrack(){
        let alert = UIAlertController(title: "Track Order".localized, message: "Please Enter Order number or AWB number".localized, preferredStyle: UIAlertController.Style.alert)
        
        alert.addTextField { (textField) in
            textField.placeholder = "Order Number".localized
            textField.font = Theme.Font.CairoRegular.withSize(15)
            textField.borderStyle = .none
        }
//        alert.addTextField { (textField) in
//            textField.placeholder = "AWB number"
//            textField.font = Theme.Font.CairoRegular.withSize(15)
//            textField.borderStyle = .none
//        }

        let okAction = UIAlertAction(title: "OK".localized, style: .default) { (alertAction) in
            let textField = alert.textFields![0] as UITextField
//            let textField2 = alert.textFields![1] as UITextField

//            alert.textFields![0].text = ""
//            alert.textFields![1].text = ""
            
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "OrderTrackVC") as! OrderTrackVC
            let o = Order.init(JSON: ["OrderNumber" : textField.text!])
            vc.order = o
            self.navigationController?.pushViewController(vc, animated: true)
        }
        
        let cancelAction = UIAlertAction(title: "CANCEL".localized, style: .default) { (alertAction) in
            print("cancel tapped")
        }
        
        alert.addAction(okAction)
        alert.addAction(cancelAction)
        
        self.present(alert, animated: true, completion: nil)
    }
    
    override func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return (indexPath.row == 0) ? UITableView.automaticDimension : 44
    }
    
    
    
}
