//
//  TabBarVC.swift
//  We1l
//
//  Created by Yahya Tabba on 2/10/19.
//  Copyright © 2019 Yahya Tabba. All rights reserved.
//

import UIKit
import JGProgressHUD
import SwiftyJSON

class TabBarVC: UITabBarController {

    var hud = JGProgressHUD.init(style: JGProgressHUDStyle.dark)
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        for i in tabBar.items!{
            i.title = nil
            i.image = i.image?.resized(toWidth: 24)?.withRenderingMode(.alwaysTemplate)
            i.selectedImage = i.selectedImage?.resized(toWidth: 24)?.withRenderingMode(.alwaysOriginal)

            i.imageInsets = UIEdgeInsets.init(top: 6, left: 0, bottom: -6, right: 0)
            i.setBadgeTextAttributes([NSAttributedString.Key.font : Theme.Font.CairoRegular.withSize(8)], for: UIControl.State.normal)
            i.badgeColor = Theme.Color.blue
        }
        
        Provider.tabBar = self
        
        
        
    }
    
    func refreshCart(){
        if Provider.Cart.isEmpty{
            tabBar.items![2].badgeValue = nil
        }else{
            tabBar.items![2].badgeValue = "\(Provider.Cart.count)"
            tabBar.items![2].badgeColor = Theme.Color.blue
            tabBar.items![2].setBadgeTextAttributes([NSAttributedString.Key.font : Theme.Font.CairoRegular.withSize(10),NSAttributedString.Key.strokeColor : UIColor.white], for: .normal)
        }
//        self.loopThrowViews(view: tabBar)
    }
    
    func showLoading(_ text : String! = nil){
        hud.indicatorView = JGProgressHUDIndeterminateIndicatorView.init()
        hud.textLabel.text = text
        hud.show(in: self.view, animated: false)
    }
    
    func hideLoading(){
        self.hud.dismiss(animated : false)
    }

    /*
    func loopThrowViews(view:UIView){
        for subview in (view.subviews){
            let t = type(of: subview)
            let type = String.init(describing: t)
            if type == "_UIBadgeView" {
                print("this is BadgeView")
                animateView(view: subview)
            }
            else {
                loopThrowViews(view:subview)
            }
            
        }
    }
    
    func animateView(view:UIView){
        let shakeAnimation = CABasicAnimation(keyPath: "position")
        shakeAnimation.duration = 0.05
        shakeAnimation.repeatCount = 2
        shakeAnimation.autoreverses = true
        shakeAnimation.fromValue = NSValue(cgPoint: CGPoint(x:view.center.x - 10, y:view.center.y))
        shakeAnimation.toValue = NSValue(cgPoint: CGPoint(x:view.center.x + 10, y:view.center.y))
        view.layer.add(shakeAnimation, forKey: "position")
    }*/




}
